<?php         

/**
 * ab_google_maps package for Concrete5
 * Copyright Copyright 2018-2019, Alex Borisov
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_google_maps
 */
 
namespace Concrete\Package\AbGoogleMaps;

use Concrete\Core\Package\Package;
use Concrete\Core\Block\BlockType\BlockType;

class Controller extends Package {

	protected $pkgHandle = 'ab_google_maps';
	protected $appVersionRequired = '8.3.2';
	protected $pkgVersion = '1.0.0';
	protected $pkgAutoloaderMapCoreExtensions = true;
	
    public function getPackageDescription() 
	{
		return t('Free Google Maps package');
	}
	
	public function getPackageName() 
	{
		return t("Free Google Maps");
	}
	
	public function install() 
	{
		$pkg = parent::install();
		BlockType::installBlockType('ab_google_maps', $pkg);
	}

}
