<?php
namespace Concrete\Package\SocialFeed;
use Concrete\Core\Package\Package;
use Concrete\Core\Block\BlockType\BlockType;
use Route;
use Job;

defined('C5_EXECUTE') or die(_("Access Denied."));

class Controller extends Package {

	protected $pkgHandle = 'social_feed';
	protected $appVersionRequired = '5.7.0.4';
	protected $pkgVersion = '1.1.5';


	public function getPackageDescription() {
		return t("Easily add your social media feed to the website.");
	}

	public function getPackageName() {
		return t("Easy Social Feed");
	}

	public function on_start() {
		$al = \Concrete\Core\Asset\AssetList::getInstance();
		$al->register(
		'javascript', 'timeago', 'blocks/easy_social_feed/js/timeago.js',
		array('version' => '2.0.5', 'minify' => true, 'combine' => true),
		$this);
		$al->register(
		'javascript', 'masonry', 'blocks/easy_social_feed/js/masonry.pkgd.min.js',
		array('version' => '4.1.1', 'minify' => false, 'combine' => true),
		$this);
		$al->register(
		'javascript', 'imagesloaded', 'blocks/easy_social_feed/js/imagesloaded.pkgd.min.js',
		array('version' => '4.1.1', 'minify' => false, 'combine' => true),
		$this);
		$al->registerGroup('easy_social_feed', array(
			array('javascript', 'timeago'),
			array('javascript', 'masonry'),
			array('javascript', 'imagesloaded')
		));

		require_once __DIR__. '/blocks/easy_social_feed/vendor/Facebook/autoload.php';
		require_once __DIR__. '/blocks/easy_social_feed/vendor/Twitter/autoload.php';
		require_once __DIR__. '/blocks/easy_social_feed/vendor/Instagram/autoload.php';

		Route::register( '/easy_social_feed/get/{bID}/{account}/{skip}', 'Concrete\Package\SocialFeed\Block\EasySocialFeed\Controller::get_data_ajax' );
	}

	public function install() {
		$pkg = parent::install();
		// install block
		BlockType::installBlockType('easy_social_feed', $pkg);
		Job::installByPackage("social_feed_update", $pkg);
	}

	public function uninstall()
	{
		parent::uninstall();
		$db = \Database::connection();
		$db->query('drop table if exists btEasySocialFeed');
		$db->query('drop table if exists btEasySocialFeedEntries');
	}
}
?>
