<?php
namespace Concrete\Package\AbContactForm\Captcha;

use Securimage;
use Securimage_Color;

/**
 * ab_contact_form package for Concrete5
 * concrete5.org marketplace license
 * Copyright Copyright 2017-2018, Alex Borisov
 *
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_contact_form
 */

class AbCaptchaController extends \Concrete\Core\Captcha\SecurimageController
{
    public function displayCaptchaPicture()
    {
        $this->securimage->image_width = 240;
		$this->securimage->image_height = 60;
		$this->securimage->image_bg_color = new Securimage_Color('#cceeff');
		$this->securimage->line_color = new Securimage_Color('#696969');
		
		$this->securimage->text_color = new Securimage_Color('#FF4100');
		$this->securimage->use_transparent_text = true;
		$this->securimage->text_transparency_percentage = 40;
		
		$this->securimage->image_signature = parse_url(BASE_URL, PHP_URL_HOST);
		$this->securimage->signature_color = new Securimage_Color('#363636');
		$this->securimage->code_length = rand(4, 6);
		$this->securimage->num_lines = rand(3, 10);
		
        return parent::displayCaptchaPicture();
    }
}
