<?php namespace Concrete\Package\LiveChat\Controller\SinglePage\Dashboard\System\LiveChat;

defined('C5_EXECUTE') or die("Access Denied.");

use AssetList;
use Concrete\Core\Page\Controller\DashboardPageController;
use Concrete\Package\LiveChat\Src\LiveChatConfig;
use Core;
use Request;
use Symfony\Component\HttpFoundation\JsonResponse;

class Settings extends DashboardPageController
{
	protected $packageHandle = 'live_chat';

	public function view($extra = '')
	{
		$post = [];
		$postData = Request::post();
		if (!empty($postData)) {
			if ($this->validateForm()) {
				LiveChatConfig::save('widget.hide', isset($postData['hide']) && $postData['hide'] == '1' ? true : false);
				LiveChatConfig::save('widget.hide_edit_mode', isset($postData['hide_edit_mode']) && $postData['hide_edit_mode'] == '1' ? true : false);
				LiveChatConfig::save('widget.hide_dashboard', isset($postData['hide_dashboard']) && $postData['hide_dashboard'] == '1' ? true : false);
				LiveChatConfig::save('widget.use_cache', isset($postData['use_cache']) && $postData['use_cache'] == '1' ? true : false);
				$this->redirect(sprintf('/dashboard/system/%s/settings/saved', $this->packageHandle));
			} else {
				$this->redirect(sprintf('/dashboard/system/%s/settings/token_error', $this->packageHandle));
			}
		} else {
			$post['hide'] = LiveChatConfig::get('widget.hide');
			$post['hide_edit_mode'] = LiveChatConfig::get('widget.hide_edit_mode');
			$post['hide_dashboard'] = LiveChatConfig::get('widget.hide_dashboard');
			$post['use_cache'] = LiveChatConfig::get('widget.use_cache');
			switch ($extra) {
				case 'token_error':
					$this->set('errors', [t("The form token was invalid. Refresh the page and try again.")]);
					break;
				case 'saved':
					$this->set('message', t("Settings saved."));
					break;
			}
		}
		$baseURL = LiveChatConfig::getBaseURL();
		$pageID = LiveChatConfig::get('widget.pageID');
		$type = LiveChatConfig::get('widget.type');
		$queryData = [
			'currentWidgetId'       => $type,
			'currentPageId'         => $pageID,
			'transparentBackground' => '1',
		];
		$iFrameURL = sprintf('%s/generic/widgets', $baseURL);
		if (!empty($queryData)) {
			$iFrameURL .= '?' . http_build_query($queryData);
		}
		$al = AssetList::getInstance();
		$al->register('css', 'live-chat', 'css/liveChat.css', [], $this->packageHandle);
		$this->requireAsset('css', 'live-chat');
		$this->set('post', $post);
		$this->set('iFrameURL', $iFrameURL);
		$this->set('baseURL', $baseURL);
		$this->set('cacheMinutes', LiveChatConfig::getCacheMinutes());
	}

	protected function validateForm()
	{
		$validationForm = Core::make('helper/validation/form');
		$validationForm->addRequiredToken('live_chat_options');
		return $validationForm->test();
	}

	public function set_widget()
	{
		$errors = [];
		$post = Request::post();
		$success = false;
		if (!isset($post['pageId']) || trim($post['pageId']) == '') {
			$errors[] = t('The %s field is required.', t("Site"));
		} elseif (preg_match('/^[0-9A-Fa-f]{24}$/', $post['pageId']) !== 1) {
			$errors[] = t('The %s field has an incorrect value.', t("Site"));
		}
		if (!isset($post['widgetId']) || trim($post['widgetId']) == '') {
			$errors[] = t('The %s field is required.', t("Widget"));
		} elseif (preg_match('/^[a-z0-9]{1,50}$/i', $post['widgetId']) !== 1) {
			$errors[] = t('The %s field has an incorrect value.', t("Widget"));
		}
		if (empty($errors)) {
			$success = true;
			LiveChatConfig::save('widget.pageID', $post['pageId']);
			LiveChatConfig::save('widget.type', $post['widgetId']);
		}
		return new JsonResponse(
			[
				'success' => $success,
				'errors'  => $errors,
			]
		);
	}

	public function remove_widget()
	{
		LiveChatConfig::save('widget.pageID', '');
		LiveChatConfig::save('widget.type', '');
		return new JsonResponse(
			[
				'success' => true,
			]
		);
	}
}