<?php defined('C5_EXECUTE') or die("Access Denied."); ?>
<?php
if (isset($errors) && !empty($errors)) {
	?>
	<div class="alert alert-danger">
		<i class="fa fa-exclamation-circle" aria-hidden="true"></i>
		<?php echo implode('<br/>', $errors); ?>
	</div>
	<?php
} ?>

<h2><?php echo t("Plugin Settings"); ?></h2>

<p>
	<?php echo t("If you haven't created a %s account or haven't logged in yet, use the button or sign in form available below. When you have selected to use an available widget, those settings will be saved (also if you logout or will be logged out automatically). More widgets can be created using the %s.", sprintf('<a href="%s" target="_blank">%s</a>', 'https://www.tawk.to/', 'Tawk.to'), sprintf('<a href="%s" target="_blank">%s</a>', 'https://dashboard.tawk.to', t('Tawk.to dashboard'))); ?>
</p>

<iframe id="tawkIframe"></iframe>

<script type="text/javascript">
	jQuery('#tawkIframe').attr('src', "<?php echo $iFrameURL; ?>&parentDomain=" + window.location.protocol + "//" + window.location.host);
	window.addEventListener('message', function (e) {
		if (e.origin === '<?php echo $baseURL; ?>') {
			switch (e.data.action) {
				case 'setWidget':
					var postData = {
						pageId: e.data.pageId,
						widgetId: e.data.widgetId
					};
					jQuery.post('<?php echo $this->action('set_widget'); ?>', postData, function (r) {
						var action = r.success ? 'setDone' : 'setFail';
						e.source.postMessage({action: action}, '<?php echo $baseURL; ?>');
						location.reload();
					});
					break;
				case 'removeWidget':
					jQuery.post('<?php echo $this->action('remove_widget'); ?>', {}, function (r) {
						var action = r.success ? 'removeDone' : 'removeFail';
						e.source.postMessage({action: action}, '<?php echo $baseURL; ?>');
						location.reload();
					});
					break;
			}
		}
	});
</script>

<h2><?php echo t("Visibility Options"); ?></h2>

<form action="<?php echo $this->action('view'); ?>" method="post">
	<fieldset>
		<?php echo Core::make('helper/validation/token')->output('live_chat_options'); ?>

		<div class="form-group">
			<label class="control-label">
				<?php echo $form->checkbox('hide', 1, $post['hide']); ?>
				<?php echo t("Hide in website"); ?>
			</label>
		</div>

		<div class="form-group">
			<label class="control-label">
				<?php echo $form->checkbox('hide_edit_mode', 1, $post['hide_edit_mode']); ?>
				<?php echo t("Hide in website's '%s'", t("Edit Mode")); ?>
			</label>
		</div>

		<div class="form-group">
			<label class="control-label">
				<?php echo $form->checkbox('hide_dashboard', 1, $post['hide_dashboard']); ?>
				<?php echo t("Hide in dashboard"); ?>
			</label>
		</div>

		<div class="form-group">
			<label class="control-label">
				<?php echo $form->checkbox('use_cache', 1, $post['use_cache']); ?>
				<?php echo t("Use cache - %s", t("%s minutes", $cacheMinutes)); ?>
			</label>
		</div>

		<div class="ccm-dashboard-form-actions-wrapper">
			<div class="ccm-dashboard-form-actions">
				<button class="pull-right btn btn-primary" type="submit">
					<?php echo t("Save"); ?>
				</button>
			</div>
		</div>
	</fieldset>
</form>

<h2><?php echo t("Multilingual Setup"); ?></h2>

<p>
	<a href="<?php echo URL::to('/dashboard/system/live_chat/multilingual_setup'); ?>" class="btn btn-primary">
		<i class="fa fa-flag" aria-hidden="true"></i>
		<?php echo t("Go to %s", t("Multilingual Setup")); ?>
	</a>
</p>