<?php  namespace Concrete\Package\Eightbit\Block\BitButton;
use Concrete\Core\Block\BlockController;
use Core;
use Page;

defined('C5_EXECUTE') or die("Access Denied.");

class Controller extends BlockController {
	
	protected $btTable = 'btBitButton';
	protected $btInterfaceWidth = "508";
	protected $btInterfaceHeight = "408";
	protected $btWrapperClass = 'ccm-ui';
	protected $btCacheBlockRecord = true;
	protected $btCacheBlockOutput = true;
	protected $btDefaultSet = 'eightbit';

	public function getBlockTypeName() {
		return t("Bit Button");
	}	
	
	public function getBlockTypeDescription() {
		return t("Add an 8-bit style button!");
	}

	public function getSearchableContent(){
		return $this->buttonText;
	}	

	function getExternalLink() {return $this->externalLink;}
	function getInternalLinkCID() {return $this->internalLinkCID;}
	function getLinkURL() {
		if (!empty($this->externalLink)) {
			return $this->externalLink;
		} else if (!empty($this->internalLinkCID)) {
			$linkToC = Page::getByID($this->internalLinkCID);
			return (empty($linkToC) || $linkToC->error) ? '' : Core::make('helper/navigation')->getLinkToCollection($linkToC);
		} else {
			return '';
		}
	}

	public function save($args) {
		switch (intval($args['linkType'])) {
			case 1:
				$args['externalLink'] = '';
				break;
			case 2:
				$args['internalLinkCID'] = 0;
				break;
			default:
				$args['externalLink'] = '';
				$args['internalLinkCID'] = 0;
				break;
		}
		unset($args['linkType']); //this doesn't get saved to the database (it's only for UI usage)
		parent::save($args);	
	}
	
	public function validate($args) {
        $e = Core::make("helper/validation/error");       
        if(empty($args['buttonText'])){
            $e->add(t("Button text cannot be empty."));
        }
        return $e;
    }
}
?>