<?php  
namespace Concrete\Package\Eightbit;
use Concrete\Core\Package\Package;
use Concrete\Core\Page\Theme\Theme;
use PageTemplate;
use Database;
use BlockType;
use AssetList;
use \Concrete\Core\Asset\Asset;
use BlockTypeSet;
use CollectionAttributeKey;
use Concrete\Core\Attribute\Type as AttributeType;

defined('C5_EXECUTE') or die("Access Denied.");

class Controller extends Package
{

    protected $pkgHandle = 'eightbit';
    protected $appVersionRequired = '5.7.4';
    protected $pkgVersion = '1.0';
    protected $pkgAllowsFullContentSwap = false;

    public function getPackageName() {
        return t("8Bit");
    }

    public function getPackageDescription() {
        return t("A theme for retro gamers and tech geeks.");
    }
	
	public function on_start() {
		$al = AssetList::getInstance();
		$al->register( 'javascript', 'pixelbit', 'js/jquery.instapixel.js',
	 		array('version' => '1.0.0', 'position' => Asset::ASSET_POSITION_HEADER, 'minify' => false, 'combine' => false), $this
	 	);
		$al->register( 'javascript', 'modernizer', '//cdnjs.cloudflare.com/ajax/libs/modernizr/2.6.2/modernizr.min.js', array('local' => false, 'position' => ASSET::ASSET_POSITION_HEADER));
	}
	
    public function install() {
        $pkg = parent::install();
        Theme::add('eightbit', $pkg);
		// install blocks
		BlockTypeSet::add("eightbit","8Bit", $pkg);
		BlockType::installBlockType('bit_button', $pkg);
		BlockType::installBlockType('cover_bit', $pkg);
		// install page attributes
		$imgAttr = AttributeType::getByHandle('image_file'); 
  		$thumb = CollectionAttributeKey::getByHandle('thumbnail'); 
		if(!is_object($thumb)) {
	     	CollectionAttributeKey::add($imgAttr, 
	     	array(
	     		'akHandle' => 'thumbnail', 
	     		'akName' => t('Thumbnail Image'), 
	     	),$pkg);
	  	}
		$this->pageTemplates($pkg);
    }
	
	private function pageTemplates($pkg) {
        if (!PageTemplate::getByHandle('full')) {
            PageTemplate::add('full', t('Full'), 'full.png', $pkg);
        }
		if (!PageTemplate::getByHandle('two_columns')) {
            PageTemplate::add('two_columns', t('Two Columns'), 'two_column.png', $pkg);
        }
	}
	
	public function uninstall(){
		parent::uninstall();
		$db = Database::connection();
		$db->executeQuery('DROP TABLE IF EXISTS btBitButton, btCoverBit');
	}
}
