<?php
namespace Concrete\Package\SocialStream\Controller\SinglePage\Dashboard\SocialStream;

use \Concrete\Core\Page\Controller\DashboardPageController;
use Package;
use File;

class Settings extends DashboardPageController {

    public function view()
    {
        $pkg = Package::getByHandle('social_stream');
        $ss_notes = $pkg->getConfig()->get('social_stream.ss_notes');
		
        $this->set('ss_notes', $ss_notes);
    }

    public function updated()
    {
        $this->set('message', t("Settings saved."));    
        $this->view();
    }
    
    public function save_settings()
    {
        if ($this->token->validate("save_settings")) {
            if ($this->isPost()) {
                $ss_notes = $this->post('ss_notes');
                $pkg = Package::getByHandle('social_stream');
                $pkg->getConfig()->save('social_stream.ss_notes', $ss_notes);
                $this->redirect('/dashboard/social_stream/settings','updated');
            }
        } else {
            $this->set('error', array($this->token->getErrorMessage()));
        }
    }

}