<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<fieldset>
    <legend><?php echo t('Defaults'); ?></legend>
    <div class="form-group">
        <?php echo $form->label('defaultLevel', t('Default Level')); ?>
        <?php echo $form->select('defaultLevel', [0 => t('Easy'), 1 => t('Medium'), 2 => t('Hard')], $defaultLevel); ?>
        <small class="text-muted"><?php echo t('Choose the difficulty level that the game will start with.'); ?></small>
    </div>
</fieldset>  

<fieldset>
    <legend><?php echo t('Display'); ?></legend>

    <div class="form-group">
        <div class="checkbox">
            <label>
                <?php echo $form->checkbox('displayNewGameBtn', 1, $displayNewGameBtn); ?>
                <?php echo t('Display "New Game" Button'); ?>
            </label>
        </div>
        <small class="text-muted"><?php echo t('Allow users to start new game.'); ?></small>
    </div>
    
    <div class="form-group displayLevelsChoice" style="display: none;">
        <div class="checkbox">
            <label>
                <?php echo $form->checkbox('displayLevelsChoice', 1, $displayLevelsChoice); ?>
                <?php echo t('Display Levels Choices'); ?>
            </label>
        </div>
        <small class="text-muted"><?php echo t('Allow users to choose difficulty level.'); ?></small>
    </div>

    <div class="form-group">
        <div class="checkbox">
            <label>
                <?php echo $form->checkbox('displaySolveItBtn', 1, $displaySolveItBtn); ?>
                <?php echo t('Display "Solve It" Button'); ?>
            </label>
        </div>
        <small class="text-muted"><?php echo t('Users can see the solution when they click on "Solve It" button.'); ?></small>
    </div>

</fieldset>

<script>
    $(function(){
        if($('#displayNewGameBtn').is(':checked')){
            $('div.form-group.displayLevelsChoice').show();
        }else{
            $('div.form-group.displayLevelsChoice').hide();
        }
        $('#displayNewGameBtn').change(function(e){
            $('div.form-group.displayLevelsChoice').toggle('fade');
            $('#displayLevelsChoice').attr('checked', false);
        });
    });
</script>